/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.common.item.ItemActivationCrystal;
import wayoftime.bloodmagic.common.tile.TileMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.util.helper.RitualHelper;

public class BlockMasterRitualStone
extends Block
implements EntityBlock {
    public final boolean isInverted;

    public BlockMasterRitualStone(boolean isInverted) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(2.0f, 5.0f).m_60999_());
        this.isInverted = isInverted;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        ItemStack heldItem = player.m_21120_(hand);
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileMasterRitualStone && heldItem.m_41720_() instanceof ItemActivationCrystal) {
            if (((IBindable)heldItem.m_41720_()).getBinding(heldItem) == null) {
                return InteractionResult.FAIL;
            }
            String key = RitualHelper.getValidRitual(world, pos);
            if (!key.isEmpty()) {
                Ritual ritual = BloodMagic.RITUAL_MANAGER.getRitual(key);
                if (ritual != null) {
                    Direction direction = RitualHelper.getDirectionOfRitual(world, pos, ritual);
                    if (direction != null && RitualHelper.checkValidRitual(world, pos, ritual, direction)) {
                        if (((TileMasterRitualStone)tile).activateRitual(heldItem, player, BloodMagic.RITUAL_MANAGER.getRitual(key))) {
                            ((TileMasterRitualStone)tile).setDirection(direction);
                            if (this.isInverted) {
                                ((TileMasterRitualStone)tile).setInverted(true);
                            }
                        }
                    } else {
                        player.m_5661_((Component)new TranslatableComponent("chat.bloodmagic.ritual.notValid"), true);
                    }
                } else {
                    player.m_5661_((Component)new TranslatableComponent("chat.bloodmagic.ritual.notValid"), true);
                }
            } else {
                player.m_5661_((Component)new TranslatableComponent("chat.bloodmagic.ritual.notValid"), true);
            }
        }
        return InteractionResult.FAIL;
    }

    public void m_6786_(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        TileMasterRitualStone tile = (TileMasterRitualStone)world.m_7702_(blockPos);
        if (tile != null) {
            tile.stopRitual(Ritual.BreakType.BREAK_MRS);
        }
        super.m_6786_(world, blockPos, blockState);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tile = worldIn.m_7702_(pos);
            if (tile instanceof TileMasterRitualStone) {
                ((TileMasterRitualStone)tile).stopRitual(Ritual.BreakType.BREAK_MRS);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public void m_7592_(Level world, BlockPos pos, Explosion explosion) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileMasterRitualStone) {
            ((TileMasterRitualStone)tile).stopRitual(Ritual.BreakType.EXPLOSION);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileMasterRitualStone(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, blockPos, blockState, tile) -> {
            if (tile instanceof TileMasterRitualStone) {
                ((TileMasterRitualStone)tile).tick();
            }
        };
    }
}

